/** @file   FlameThrowerBullet.h
 * @brief   Declaration of FlameThrowerBullet class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:41 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_FLAMETHROWERBULLET_H
#define H_WWW_FLAMETHROWERBULLET_H

#include "bullet.h"


namespace WeWantWar {

/** @class  FlameThrowerBullet
 * @brief   Represents the bullet shot by FlameThrower.
 * @author  Tomi Lamminsaari
 *
 */
class FlameThrowerBullet : public Bullet
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   */
  FlameThrowerBullet( GameObject* aShooter, const eng2d::Vec2D& aPos );

  /** Destructor
   */
  ~FlameThrowerBullet();

private:
  
  /** Copy constructor
   * @param   aAnother          Reference to another FlameThrowerBullet
   */
  FlameThrowerBullet( const FlameThrowerBullet& aAnother );

  /** An assignment operator
   * @param   aAnother          Reference to another FlameThrowerBullet
   * @return  Reference to this object.
   */
  FlameThrowerBullet& operator= ( const FlameThrowerBullet& aAnother );

public:

  ///
  /// Inherited methods
  /// =================

  /** Draws this bullet.
   * @param   aBitmap           Pointer to target bitmap.
   */
  virtual void redraw( BITMAP* aBitmap ) const;

};

};  // end of namespace

#endif
